{
  Various types, routines and functions.

  1991-97 Jens B.Kristensen, 100776.1403

  Short documentation in the implementation section
}

UNIT Jbkutils;


Interface
uses
   sysutils,messages,windos,owindows,winprocs,wintypes,mmsystem;
const
   forever=false;
   HELP_FINDER=11;
type
{ Filename string, null terminated}
  Tjkfilename = array [0..fspathname] of Char;

{various delay-routines}

procedure delay(milliseconds:longint);
procedure wait(milliseconds:longint);
procedure wait_until(start,milliseconds:longint);

{Detects windows 95}
function windows95:boolean;

Implementation

function windows95:boolean;
{Checks Windows version. Windows 95 presents itself as
version 3.95 to 16-bit apps}
begin
   windows95:=((loword(getversion) div 256)>=95);
end;     


procedure delay(milliseconds:longint);
{simple delay-routine}
var tid:longint;messg:Tmsg;
begin
   tid:=timegettime; {timegettime is more accurate than gettickcount}
   repeat
      {A VCL-application could just call application.processmessages here}
      peekmessage(messg,0,0,0,pm_remove);
      if messg.message=wm_quit then
         halt(0)
      else begin
         translatemessage(messg);
         dispatchmessage(messg);
      end;
   until (timegettime-tid>=milliseconds);
end;

procedure wait(milliseconds:longint);
{Stictly OWL only!
A more avanced delay-routine. See:
Brian Long: The Borland Pascal problem solver, Addison-Wesley 1994}
const
  OkayToEnter: Boolean = True;
var tid:longint;msg:Tmsg;
begin
  if OkayToEnter then
  begin
    OkayToEnter := False;
    tid:=timegettime;
    repeat
      if PeekMessage(Msg, 0, 0, 0, pm_Remove) then
      if Msg.Message = wm_Quit then
      begin
        { If in OWL, destroy application object }
        if Application <> nil then
          Application^.Done;
        Halt;
      end
      else
        if (Application = nil) or
           not Application^.ProcessAppMsg(Msg) then
        begin
          TranslateMessage(Msg);
          DispatchMessage(Msg);
        end;
      until (timegettime-tid>=milliseconds);
      OkayToEnter := True;
  end;
end; { Wait }

procedure wait_until(start,milliseconds:longint);
{Waits until the system time is start+milliseconds}
var messg:Tmsg;
begin
   repeat
      {VCL: Aplication.processmessages}
      if peekmessage(messg,0,0,0,pm_remove)then
      begin
         translatemessage(messg);
         dispatchmessage(messg);
      end;
   until (timegettime-start>=milliseconds);
end;

end.{of unit}
